Attribute VB_Name = "MdlFileRdWt"
Option Explicit

Public Const cnt_CSV_SEPA_CHAR = ","
Public Const cnt_CSV_SEPA_2ndCHAR = ";"

Public Const cnt_CSV_WRITE_VER1000 = "1.000"    'Analysis Ver 1.000
Public Const cnt_CSV_WRITE_VER = "2.000"        'Analysis Ver 2.000

Public Const cnt_CHECK_APPLI_NAME = "ANT_Chk"

Public Const cnt_SEG_NO___TITLE = "Segment Number"
Public Const cnt_FRQ_SEGM_TITLE = "Number of Freq.Segment"
Public Const cnt_FRQ_STAR_TITLE = "START[MHz]"
Public Const cnt_FRQ_STOP_TITLE = "STOP[MHz]"
Public Const cnt_FRQ_POIN_TITLE = "POINT"
Public Const cnt_FRQ_STPW_TITLE = "START POWER[dBm]"
Public Const cnt_FRQ_SPPW_TITLE = "STOP POWER[dBm]"
Public Const cnt_FRQ_RBW__TITLE = "RBW[KHZ]"
Public Const cnt_FRQ_STTM_TITLE = "SettlingTime[msec]"

Public Const cnt_MEAS_NUM_TITLE = "Number of Measurement"
Public Const cnt_MEAS_NO_TITLE = "Measurement Number"
Public Const cnt_MEAS_TT_TITLE = "TITLE"
Public Const cnt_MEAS_JG_TITLE = "Judge Valid(ON)/Invalid(OFF)"
Public Const cnt_MEAS_TN_TITLE = "Trace Number"
Public Const cnt_MEAS_CM_TITLE = "Meas. Command"
Public Const cnt_MEAS_ST_TITLE = "START[MHz]"
Public Const cnt_MEAS_SP_TITLE = "STOP[MHz]"
Public Const cnt_MEAS_LD_TITLE = "Limit Disp"
Public Const cnt_MEAS_LC_TITLE = "LowerLimit Check"
Public Const cnt_MEAS_LW_TITLE = "LowerLimit"
Public Const cnt_MEAS_UC_TITLE = "UpperLimit Check"
Public Const cnt_MEAS_UP_TITLE = "UpperLimit"
Public Const cnt_MEAS_LF_TITLE = "Lw Freq[MHz]"
Public Const cnt_MEAS_UF_TITLE = "Up Freq[MHz]"

Public Const cnt_FREQ_TO_STR = "0.0000000000E-0"
Public Const cnt_FREQ_ADJUST As Double = 0.00000000005

Public Const cnt_RBW_TO_STR = "0.000000E-0"
Public Const cnt_RBW_ADJUST As Double = 0.0000005

Public Const cnt_STTM_TO_STR = "0.000000E-0"
Public Const cnt_STTM_ADJUST As Double = 0.0000005

Public Const cnt_LEVL_TO_STR = "0.000000E-0"

Public Const cnt_INT_TO_STR As Integer = 0
Public Const cnt_STR_TO_INT As Integer = 1

Public Const cnt_READ As Integer = 0
Public Const cnt_SAVE As Integer = 1

Public Const Unit_OpenZ0 = 0
Public Const Unit_OpenDelay = 1
Public Const Unit_OpenLoss = 2
Public Const Unit_OpenCapC0 = 3
Public Const Unit_OpenCapC1 = 4
Public Const Unit_OpenCapC2 = 5
Public Const Unit_OpenCapC3 = 6
Public Const Unit_ShortZ0 = 7
Public Const Unit_ShortDelay = 8
Public Const Unit_ShortLoss = 9
Public Const Unit_ShortIndL0 = 10
Public Const Unit_ShortIndL1 = 11
Public Const Unit_ShortIndL2 = 12
Public Const Unit_ShortIndL3 = 13
Public Const Unit_LoadZ0 = 14
Public Const Unit_LoadDelay = 15
Public Const Unit_LoadLoss = 16
Public Const Unit_LoadResistance = 17

Public Const Unit_OpenR = 0
Public Const Unit_OpenL = 1
Public Const Unit_OpenC = 2
Public Const Unit_ShortR = 7
Public Const Unit_ShortL = 8
Public Const Unit_ShortC = 9
Public Const Unit_LoadR = 14
Public Const Unit_LoadL = 15
Public Const Unit_LoadC = 16

Public Const GOHM = 1000000000#
Public Const PS = 0.000000000001

Public Const CapC0 = 0.000000000000001
Public Const CapC1 = 1E-27
Public Const CapC2 = 1E-36
Public Const CapC3 = 1E-45
Public Const IndL0 = 0.000000000001
Public Const IndL1 = 1E-24
Public Const IndL2 = 1E-33
Public Const IndL3 = 1E-42

Public Const cnt_APP_NAME_TITLE = "Application Name"
Public Const cnt_CSV_SHET_TITLE = "CSV Sheet Revsion"
Public Const cnt_BD__NUMB_TITLE = "Board Number"
Public Const cnt_IP__ADDR_TITLE = "IP Address"
Public Const cnt_PD__NAME_TITLE = "Product Name"
Public Const cnt_PD_SERNO_TITLE = "Serial Number"
Public Const cnt_PD_NUMCH_TITLE = "Number Of Channel"
Public Const cnt_CH__NO___TITLE = "Channel Title"
Public Const cnt_CAL_COR__TITLE = "CAL status (Cor/C?/C!)"
Public Const cnt_STIM_NUM_TITLE = "Number of Freq.Segment"
Public Const cnt_MEAS_____TITLE = "Measurement"
Public Const cnt_FMT_LGM__TITLE = "LOGMAG"
Public Const cnt_FMT_INF__TITLE = "Information on format "
Public Const cnt_FMT_DIV__TITLE = "/DIV"
Public Const cnt_FMT_REFV_TITLE = "Ref.VAL"
Public Const cnt_FMT_REFP_TITLE = "Ref.Pos"
Public Const cnt_LIMIT__F_TITLE = "Limit Line Freq"
Public Const cnt_LMT_CHKF_TITLE = "Check Freq"
Public Const cnt_LMT_LFRQ_TITLE = "Lw Freq"
Public Const cnt_LMT_LFP__TITLE = "Lw Freq Point"
Public Const cnt_LMT_UFRQ_TITLE = "Up Freq"
Public Const cnt_LMT_UFP__TITLE = "Up Freq Point"
Public Const cnt_LMT_FRQ__TITLE = "Freq"
Public Const cnt_LIMIT__L_TITLE = "Limit Line Level"
Public Const cnt_LMT_C_LW_TITLE = "Check Lw Level"
Public Const cnt_LMT_LWLV_TITLE = "Lw Level"
Public Const cnt_LMT_C_UP_TITLE = "Check Up Level"
Public Const cnt_LMT_UPLV_TITLE = "Up Level"
Public Const cnt_LMT_LVL__TITLE = "Level"

Public Const cnt_FILE_NOT_RE As Integer = 0             ' intFileRecall : Not Recall
Public Const cnt_FILE_RECALL As Integer = 1             ' intFileRecall : Recall

'************************************
'   Only API file name is taken out.
'************************************
Public Function FindFileName(ByVal strFileName As String) As String
    Dim strBuffer   As String
    Dim lngResult   As Long
    Dim bytStr()    As Byte

    lngResult = PathFindFileName(strFileName)
    If lngResult <> 0 Then
        ReDim bytStr(MAX_PATH + 1) As Byte
        MoveMemory bytStr(0), ByVal lngResult, MAX_PATH + 1
        strBuffer = StrConv(bytStr(), vbUnicode)
        FindFileName = Left$(strBuffer, InStr(strBuffer, vbNullChar) - 1)
    End If
End Function
'
' One-line read & line counter
'
Private Function getline(ByRef fileno As Long, ByVal lcnt As Long, ByRef aryTemp As Variant, ByRef s As String) As Long
    Dim textline As Variant
    
    lcnt = lcnt + 1
    Line Input #fileno, textline
    If 0 < InStr(1, textline, cnt_CSV_SEPA_2ndCHAR) Then s = cnt_CSV_SEPA_2ndCHAR
    aryTemp = Split(textline, s)
    getline = lcnt
End Function
'
' Reading of measurement condition from CSV Sheet
'
Private Function getdata(ByRef fileno As Long, ByVal lcnt As Long, ByRef vntTemp As Variant, ByRef s As String) As Long
    Dim lngTemp As Long

    lcnt = getline(fileno, lcnt, vntTemp, s)
    getdata = lcnt
End Function

'
'The value of ON/OFF or the character string is returned.
'
Public Sub CnvOnOffSw(ByVal flg As Integer, ByRef ss As String, ByRef sw As Integer)

    If flg = cnt_INT_TO_STR Then    'sw ->  return ss  = "ON" or "OFF"
        Select Case sw
            Case 0: ss = "OFF"
            Case 1: ss = "ON"
            Case Else: ss = "OFF"
        End Select
    Else                            ' ss -> return sw  = 0 or 1
        Select Case UCase$(ss)
            Case "OFF": sw = 0
            Case "ON": sw = 1
            Case Else: sw = -1
        End Select
    End If

End Sub

Private Function RdWtData(ByRef fno As Long, ByVal line_cnt As Long, ByRef vntData As Variant, ByRef s As String, ByVal rdwt_flg As Integer) As Long
    
    If rdwt_flg = cnt_READ Then
        line_cnt = getdata(fno, line_cnt, vntData, s)
    Else
        Print #fno, vntData
        line_cnt = line_cnt + 1
    End If
    
    RdWtData = line_cnt

End Function


Public Function dblRound(ByVal dt As Double, ByVal div_dt As Double, adj_dt As Double) As Double
    Dim l As Long
    Dim tmp As Double

    If dt = 0 Then
        dblRound = dt
    Else
        l = Fix(dt / div_dt)
        tmp = dt / div_dt - CDbl(l)
        If tmp = 0 Or dt = dt / div_dt * div_dt Then
            dblRound = dt / div_dt
        Else
            dblRound = dt / div_dt + adj_dt
        End If
    End If
End Function

'
'FORMATŎgplT[`
'
Public Function CnvFormatNameToType(ss As String) As Long
    Select Case UCase(ss)
        Case "LOGMAG": CnvFormatNameToType = WAVE_FORMAT_LOGMAG
        Case "PHASE": CnvFormatNameToType = WAVE_FORMAT__PHASE
        Case "POLAR": CnvFormatNameToType = WAVE_FORMAT__POLAR
        Case "SMITH": CnvFormatNameToType = WAVE_FORMAT__SMITH
        Case "DELAY": CnvFormatNameToType = WAVE_FORMAT__DELAY
        Case "SWR": CnvFormatNameToType = WAVE_FORMAT____SWR
        Case "REAL": CnvFormatNameToType = WAVE_FORMAT___REAL
        Case "IMAG": CnvFormatNameToType = WAVE_FORMAT___IMAG
        Case Else
            CnvFormatNameToType = WAVE_FORMAT____NON
    End Select
End Function

'
'FORMATŎgpXP[l̐ݒ
'
Public Sub CnvFormatNameToScale(tscl As struct_Trace, ss As String, dblDiv As Double, dblRef As Double, dblPos As Double)
    Select Case UCase(ss)
        Case "LOGMAG":
            tscl.Mscl.div = dblDiv: tscl.Mscl.ref = dblRef: tscl.Mscl.pos = dblPos
        Case "PHASE":
            tscl.Pscl.div = dblDiv: tscl.Pscl.ref = dblRef: tscl.Pscl.pos = dblPos
        Case "POLAR":
        Case "SMITH":
        Case "DELAY":
            tscl.Dscl.div = dblDiv: tscl.Dscl.ref = dblRef: tscl.Dscl.pos = dblPos
        Case "SWR":
            tscl.SWRscl.div = dblDiv: tscl.SWRscl.ref = dblRef: tscl.SWRscl.pos = dblPos
        Case "REAL":
            tscl.Rscl.div = dblDiv: tscl.Rscl.ref = dblRef: tscl.Rscl.pos = dblPos
        Case "IMAG":
            tscl.Iscl.div = dblDiv: tscl.Iscl.ref = dblRef: tscl.Iscl.pos = dblPos
    End Select
End Sub

Public Sub GetMeasType(ByVal flg As Integer, ByRef sstype As String, ByRef meas_type As Integer)

    If flg = cnt_INT_TO_STR Then    'sstype -> return meas_type  = "MAX" or "MIN" or "VAL" or "PWRVAL"
        Select Case meas_type
            Case McrMeasMAX: sstype = "MAX"
            Case McrMeasMIN: sstype = "MIN"
            Case McrMeasVAL: sstype = "VAL"
            Case McrMeasPWRVAL: sstype = "PWRVAL"
            Case Else
                sstype = "VAL"
                Exit Sub
        End Select
    Else                            'meas_type -> return sstype  =McrMeasMAX or McrMeasMIN or McrMeasVAL or McrMeasPWRVAL
        Select Case UCase(sstype)
            Case "MAX": meas_type = McrMeasMAX
            Case "MIN": meas_type = McrMeasMIN
            Case "VAL": meas_type = McrMeasVAL
            Case "PWRVAL": meas_type = McrMeasPWRVAL
            Case Else
                meas_type = -1
                Exit Sub
        End Select
    End If
    
    On Error GoTo err_GetMeasType

err_GetMeasType:
    On Error GoTo 0
End Sub


Private Function GetTraceNo(ch As Long, ss As String) As Long
    
    Select Case UCase(ss)
        Case "LOGMAG": GetTraceNo = 1024 * ch + BIS_TRAC1_LOGMAG
        Case "PHASE": GetTraceNo = 1024 * ch + BIS_TRAC1_PHASE
        Case "POLAR": GetTraceNo = 1024 * ch + BIS_TRAC1_UDT_RE
        Case "SMITH": GetTraceNo = 1024 * ch + BIS_TRAC1_UDT_RE
        Case "DELAY": GetTraceNo = 1024 * ch + BIS_TRAC1_PHASE
        Case "SWR": GetTraceNo = 1024 * ch + BIS_TRAC1_LINMAG
        Case "REAL": GetTraceNo = 1024 * ch + BIS_TRAC1_UDT_RE
        Case "IMAG": GetTraceNo = 1024 * ch + BIS_TRAC1_UDT_IM
        Case Else
            GetTraceNo = 1024 * ch + BIS_TRAC1_LOGMAG
    End Select
        
End Function

'*************************************************
'  Function name  Fsubstdunit
'  Function    FUnit adjustment.
'  Functional descriptionsF
'*************************************************
Public Function substdunit(code As Integer) As Double
    Select Case code
        Case Unit_OpenL, Unit_ShortL, Unit_LoadL: substdunit = Unit_p   ' 1E-12 = p
        Case Unit_OpenC, Unit_ShortC, Unit_LoadC: substdunit = Unit_f   ' 1E-15 = f
        Case Else: substdunit = 1
    End Select

End Function

'*************************************************
'  Function name  Fsubunit
'  Function    FUnit adjustment.
'  Functional descriptionsF
'*************************************************
Public Function subunit(code As Integer) As Double
    
    Select Case code
        Case Unit_OpenDelay, Unit_ShortDelay, Unit_LoadDelay:
            subunit = PS
        Case Unit_OpenLoss, Unit_ShortLoss, Unit_LoadLoss:
            subunit = GOHM
            
        Case Unit_OpenCapC0: subunit = CapC0
        Case Unit_OpenCapC1: subunit = CapC1
        Case Unit_OpenCapC2: subunit = CapC2
        Case Unit_OpenCapC3: subunit = CapC3
        
        Case Unit_ShortIndL0: subunit = IndL0
        Case Unit_ShortIndL1: subunit = IndL1
        Case Unit_ShortIndL2: subunit = IndL2
        Case Unit_ShortIndL3: subunit = IndL3
        
        Case Else: subunit = 1
    End Select
    
End Function

Public Sub SetStdCalKit_Data(code As Integer, dt As Double)
    
    dt = dt * substdunit(code)
    
    With StdCKit
        Select Case code
                Case Unit_OpenR:        .opRs = dt
                Case Unit_OpenL:        .opLs = dt
                Case Unit_OpenC:        .opCp = dt
                Case Unit_ShortR:       .shRs = dt
                Case Unit_ShortL:       .shLs = dt
                Case Unit_ShortC:       .shCp = dt
                Case Unit_LoadR:        .loRs = dt
                Case Unit_LoadL:        .loLs = dt
                Case Unit_LoadC:        .loCp = dt
        End Select
    End With

End Sub

Public Sub SetUserDefCalKit_Data(code As Integer, dt As Double)
    
    dt = dt * subunit(code)
    
    Select Case code
        Case Unit_OpenZ0:           CKit.UserDef.op_imp = dt
        Case Unit_OpenDelay:        CKit.UserDef.op_del = dt
        Case Unit_OpenLoss:         CKit.UserDef.op_loss = dt
        Case Unit_OpenCapC0:        CKit.UserDef.dblCap(0) = dt
        Case Unit_OpenCapC1:        CKit.UserDef.dblCap(1) = dt
        Case Unit_OpenCapC2:        CKit.UserDef.dblCap(2) = dt
        Case Unit_OpenCapC3:        CKit.UserDef.dblCap(3) = dt
        Case Unit_ShortZ0:          CKit.UserDef.sh_imp = dt
        Case Unit_ShortDelay:       CKit.UserDef.sh_del = dt
        Case Unit_ShortLoss:        CKit.UserDef.sh_loss = dt
        Case Unit_ShortIndL0:       CKit.UserDef.dblind(0) = dt
        Case Unit_ShortIndL1:       CKit.UserDef.dblind(1) = dt
        Case Unit_ShortIndL2:       CKit.UserDef.dblind(2) = dt
        Case Unit_ShortIndL3:       CKit.UserDef.dblind(3) = dt
        Case Unit_LoadZ0:           CKit.UserDef.lo_imp = dt
        Case Unit_LoadDelay:        CKit.UserDef.lo_del = dt
        Case Unit_LoadLoss:         CKit.UserDef.lo_loss = dt
        Case Unit_LoadResistance:   CKit.UserDef.lo_res = dt
    End Select

End Sub

Public Sub ReadCalFile(ByVal mx_ch As Long, ByVal fn As String)
    Dim fileno As Long
    Dim i As Integer
    Dim ch As Integer

    fn = Mid(fn, 1, Len(fn) - 3)
    fn = fn & "bin"
    On Error GoTo rdcalerr
    
    fileno = FreeFile
    '
    Open fn For Binary Access Read As #fileno Len = Len(ChInfo(ACT_CH1).Correct.cal1(0))
        For ch = ACT_CH1 To mx_ch - 1
            With ChInfo(ch)
                For i = 0 To .lngTotP - 1
                    With .Correct
                        Get #fileno, , .cal1(i * 2)
                        Get #fileno, , .cal1(i * 2 + 1)
                        Get #fileno, , .cal2(i * 2)
                        Get #fileno, , .cal2(i * 2 + 1)
                        Get #fileno, , .cal3(i * 2)
                        Get #fileno, , .cal3(i * 2 + 1)
                    End With
                Next i
            End With
        Next ch
    Close #fileno
    On Error GoTo 0
    Exit Sub

rdcalerr:
    MsgBox "Error:" & Str(Err.Number) & vbCrLf & Error(Err.Number), vbOKOnly Or vbCritical
    Close #fileno
    On Error GoTo 0
End Sub

Private Function ReadSetupData(fn As String, fileno As Long) As Boolean
    Dim lcnt As Long
    Dim ch As Long
    Dim s As String
    Dim aryTemp As Variant
    Dim aryOverlap As Variant
    Dim strAppliName As String
    Dim strBoardIdn As String
    Dim int_sw As Integer
    Dim Z0 As Double
    Dim strTmp As String
    Dim i As Integer
    Dim seg_cnt As Integer
    Dim RdBdId As Long
    Dim n As Integer
    Dim measSeg As Long

    '
    ' CSV t@C瑪Ƒ荀ڂϐɓǂݏo܂B
    '
    ReadSetupData = True        'ǂݏoG[EtOEZbg
    On Error GoTo ErrReadFile   'G[̃Wvw
    '
    s = cnt_CSV_SEPA_CHAR       'CSVt@C؂R[hw
    
    lcnt = 0                    'ǂݎsJEg
    
    ' Application Name
    lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
    strAppliName = CStr(aryTemp(1))
    
    If UCase(strAppliName) <> UCase(cnt_CHECK_APPLI_NAME) Then GoTo ErrReadFile
    
    ' CSV Sheet Revsion
    lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
    strCsvVer = CDbl(aryTemp(1))
        
    ' Product Name
    lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
    NA_ProductName = CStr(aryTemp(1))
    If frmMain.OptConnect(1).Value = True Then
        If 0 = InStr(NA_ConnectProductName, NA_ProductName) Then
            MsgBox "Connect Product Name [ " & NA_ConnectProductName & " ]: " & vbCrLf & vbCrLf & _
                    "Read Product Name [ " & NA_ProductName & " ]", vbOKOnly Or vbCritical
            GoTo ErrProductType
        End If
    End If
    
    'CAL Data File Save/Recall Flag
    lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
    Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(1)), int_sw)
    RdCsvInfo.CalSvRcFlg = int_sw
    
    ' CAL Type (Don't@Care / User Define / 3.5mm / 3.5mm(R&S))
    lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
    strTmp = CStr(aryTemp(1))
    If strTmp = "Don't@Care" Then
        CKit.CKitType = 0
    ElseIf strTmp = "Don't Care" Then
        CKit.CKitType = 0
    ElseIf strTmp = "User Define" Then
        CKit.CKitType = 1
    ElseIf strTmp = "3.5mm" Then
        CKit.CKitType = 2
    ElseIf strTmp = "3.5mm(R&S)" Then
        CKit.CKitType = 3
    Else
        GoTo ErrReadFile
    End If
  
    ' User Cal Kit Connect Type (Female/Male)
    lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
    strTmp = CStr(aryTemp(1))
    If strTmp = "Female" Then
        CKit.PortSex = BIS_FEMALE
    Else
        CKit.PortSex = BIS_MALE
    End If
        
    If 0 < InStr(NA_ProductName, "R3760") Then
        'User Cal Kit OPEN Item Title
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        'OPEN Calibration data
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        For i = Unit_OpenZ0 To Unit_OpenCapC3
            Call SetUserDefCalKit_Data(i, CDbl(aryTemp(i + 1)))
        Next i
        
        'User Cal Kit SHORT Item Title
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        'SHORT Calibration data
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        For i = Unit_ShortZ0 To Unit_ShortIndL3
            Call SetUserDefCalKit_Data(i, CDbl(aryTemp(i - Unit_OpenCapC3)))
        Next i
        
        'User Cal Kit LOAD Item Title
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        'LOAD Calibration data
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        For i = Unit_LoadZ0 To Unit_LoadResistance
            Call SetUserDefCalKit_Data(i, CDbl(aryTemp(i - Unit_ShortIndL3)))
        Next i
    Else
        'Standard Cal Kit OPEN Item Title
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        'OPEN Calibration data
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        With StdCKit
            Call SetStdCalKit_Data(Unit_OpenR, CDbl(aryTemp(1)))
            Call SetStdCalKit_Data(Unit_OpenL, CDbl(aryTemp(2)))
            Call SetStdCalKit_Data(Unit_OpenC, CDbl(aryTemp(3)))
        End With
        
        'Standard Cal Kit SHORT Item Title
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        'SHORT Calibration data
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        With StdCKit
            Call SetStdCalKit_Data(Unit_ShortR, CDbl(aryTemp(1)))
            Call SetStdCalKit_Data(Unit_ShortL, CDbl(aryTemp(2)))
            Call SetStdCalKit_Data(Unit_ShortC, CDbl(aryTemp(3)))
        End With
        
        'Standard Cal Kit LOAD Item Title
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        'LOAD Calibration data
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        With StdCKit
            Call SetStdCalKit_Data(Unit_LoadR, CDbl(aryTemp(1)))
            Call SetStdCalKit_Data(Unit_LoadL, CDbl(aryTemp(2)))
            Call SetStdCalKit_Data(Unit_LoadC, CDbl(aryTemp(3)))
        End With
    End If
        
    ' PIO-Output Data
    RdCsvInfo.IniPio = BIS_OFF
    
    ' Number Of Channel
    lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
    If cnt_PD_NUMCH_TITLE <> aryTemp(0) Then GoTo ErrReadFile
    RdCsvInfo.ChNum = CLng(aryTemp(1))
    
    If (MAX_CH + 1) < RdCsvInfo.ChNum Then GoTo ErrReadFile
    
    MeasNum = 0
    
    For ch = 0 To RdCsvInfo.ChNum - 1
        ' Channel Title
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        
        'Waveform display
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(1)), int_sw)
        ChInfo(ch).intWaveDisp = int_sw
        
        ' Measurement (A/R, A, R, S21, S11)
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
            For n = 0 To frmCH.Option_msr.UBound
                If frmCH.Option_msr(n).Caption = CStr(aryTemp(1)) Then
                    Exit For
                End If
            Next n
            
            If n = 0 Then
                ChInfo(ch).SelectMeas = BIS_MEAS_AR
                ChInfo(ch).SelectMeasType = McrMeas_AR
            ElseIf n = 1 Then
                ChInfo(ch).SelectMeas = BIS_MEAS_A
                ChInfo(ch).SelectMeasType = McrMeas__A
            ElseIf n = 2 Then
                ChInfo(ch).SelectMeas = BIS_MEAS_R
                ChInfo(ch).SelectMeasType = McrMeas__R
            ElseIf n = 3 Then
                ChInfo(ch).SelectMeas = BIS_MEAS_S21
                ChInfo(ch).SelectMeasType = McrMeasS21
            ElseIf n = 4 Then
                ChInfo(ch).SelectMeas = BIS_MEAS_S11
                ChInfo(ch).SelectMeasType = McrMeasS11
            ElseIf n = 5 Then
                If lngExpSwBox <> SWBOX_DPDT Then GoTo ErrReadFile
                ChInfo(ch).SelectMeas = BIS_MEAS_S21
                ChInfo(ch).SelectMeasType = McrMeasS12
            ElseIf n = 6 Then
                If lngExpSwBox <> SWBOX_DPDT Then GoTo ErrReadFile
                ChInfo(ch).SelectMeas = BIS_MEAS_S11
                ChInfo(ch).SelectMeasType = McrMeasS22
            End If
            
        ' CAL Method (Norm/Trans/1 Port)
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        strTmp = CStr(aryTemp(1))
        If strTmp = "Norm" Then
            ChInfo(ch).CorMeth = BIS_CAL_NORM
        ElseIf strTmp = "Trans" Then
            ChInfo(ch).CorMeth = BIS_CAL_TRANS
        ElseIf strTmp = "1 Port" Then
            ChInfo(ch).CorMeth = BIS_CAL_1PORT
        Else
            GoTo ErrReadFile
        End If
                       
        If CDbl(cnt_CSV_WRITE_VER1000) < CDbl(strCsvVer) Then
            ' Setting of each port Title
            lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
            ' Port Extension (psec)
            lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
            ChInfo(ch).Correct.PortExtCorrTime = CDbl(aryTemp(1)) * PS
            ' Port Impedance (ohm)
            lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
            ChInfo(ch).ImpZ0 = CDbl(aryTemp(1))
        Else
            ChInfo(ch).Correct.PortExtCorrTime = 0
            ChInfo(ch).ImpZ0 = 50
        End If
        
        ' PIO-Output Data
        With ChInfo(ch)
            If .SelectMeasType = McrMeasS22 Or .SelectMeasType = McrMeasS12 Then
                ChInfo(ch).Pio = BIS_ON
            Else
                ChInfo(ch).Pio = BIS_OFF
            End If
        End With
        
        ' Number of Freq.Segment
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        If cnt_STIM_NUM_TITLE <> aryTemp(0) Then GoTo ErrReadFile

        ChInfo(ch).StimuNum = CInt(aryTemp(1))
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        For i = 0 To ChInfo(ch).StimuNum - 1
            lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
            With CH_Stimu(i, ch)
                .dblFreq1 = CDbl(aryTemp(1)) * Unit_mega
                .dblFreq2 = CDbl(aryTemp(2)) * Unit_mega
                .lngPntN = CLng(aryTemp(3))
                .lngFmode = BIS_FREQ_LIN
                .lngFtype = BIS_FREQ_STRSTP
                .sngPow1 = CDbl(aryTemp(4))
                .sngPow2 = CDbl(aryTemp(5))
                .sngRbw = CLng(CDbl(aryTemp(6)) * Unit_k)
                .sngStime = CDbl(aryTemp(7)) * Unit_m
            End With
        Next i
                 
        'Number of Trace
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        ChInfo(ch).trcNum = CInt(aryTemp(1))
        
        ReDim Preserve ChInfo(ch).trc(0 To ChInfo(ch).trcNum) As struct_TrcInfo
        
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        For i = 0 To ChInfo(ch).trcNum - 1
            lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
            With ChInfo(ch).trc(i)
                .trcNo = i
                .strFormat = CStr(aryTemp(1))       'Trace Wave Format "LOGMAG/SWR..."
                ChInfo(ch).strWaveFrmt = .strFormat
                ChInfo(ch).WaveFrmt = ChInfo(ch).WaveFrmt Or CnvFormatNameToType(CStr(aryTemp(1)))
                Call CnvFormatNameToScale(ChInfo(ch).Trace, .strFormat, CDbl(aryTemp(2)), CDbl(aryTemp(3)), CDbl(aryTemp(4)))
            End With
        Next i
        
        'Number Of Measurement
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        ChInfo(ch).MeasSegNum = CInt(aryTemp(1))

        measSeg = ChInfo(ch).MeasSegNum
        MeasNum = MeasNum + measSeg
        ReDim Preserve ChInfo(ch).trc(0 To measSeg) As struct_TrcInfo

        If MeasItemNum < measSeg Then
            MeasItemNum = measSeg
            ReDim Preserve MeasInfo(0 To MAX_CH, 0 To MeasItemNum) As struct_measInfo
        End If
        
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        For i = 0 To measSeg - 1                                    'CH ̑荀ڐ
            lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
            With MeasInfo(ch, i)
                .SegNumb = CLng(aryTemp(0))                         'ZOgԍi_~[j
                If i + 1 <> .SegNumb Then GoTo ErrReadFile
                .Title = CStr(aryTemp(1))                           'Measurement Number
                 Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(2)), .JudgeValid) 'Judge Valid(ON)/Invalid(OFF)
                If .JudgeValid = -1 Then GoTo ErrReadFile
                .RefFmtNo = CLng(aryTemp(3))                        'Trace Number
                .TrcNumb = GetTraceNo(ch, ChInfo(ch).trc(.RefFmtNo - 1).strFormat)  'Get BNA Trace Number
                 Call GetMeasType(cnt_STR_TO_INT, CStr(aryTemp(4)), .MeasType)      'Meas. CommandiMAX(0),MIN(1),VAL(2),PWRVAL(3)j
                If .MeasType = -1 Then GoTo ErrReadFile
                If .MeasType = McrMeasPWRVAL Then                   'Power Sweep
                    .Start = CDbl(aryTemp(5))                       'START[MHz] -> Pow1 Level[dBm]
                    .Stop = CDbl(aryTemp(6))                        'STOP[MHz]  -> Pow2 Level[dBm]
                Else
                    .Start = CDbl(aryTemp(5)) * Unit_mega           'START[MHz]
                    .Stop = CDbl(aryTemp(6)) * Unit_mega            'STOP[MHz]
                End If
                 Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(7)), .LmtDspFlg) 'Limit Line Display (ON/OFF)
                 Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(8)), .LwLmtLvlFlg) 'Level Lower Limit Check (ON/OFF)
                .LwLmtLvl = CSng(aryTemp(9))                        'Level LowerL imit
                 Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(10)), .UpLmtLvlFlg) 'Level Upper Limit Check (ON/OFF)
                .UpLmtLvl = CSng(aryTemp(11))                       'Level Upper Limit
                .LwLmtFrq = CDbl(aryTemp(12)) * Unit_mega           'Freq Lower Limit
                .UpLmtFrq = CDbl(aryTemp(13)) * Unit_mega           'Freq Upper Limit
                If .MeasType = McrMeasMAX Or .MeasType = McrMeasMIN Then
'                    If .LwLmtFrq <> 0 And .UpLmtFrq <> 0 And .LwLmtFrq = .UpLmtFrq Then GoTo ErrReadFile
                    If .LwLmtFrq <> 0 And .UpLmtFrq <> 0 And .LwLmtFrq = .UpLmtFrq Then .MeasType = McrMeasVAL
                End If
            End With
        Next i
    Next ch
    
    ReDim MeasData(0 To MeasNum) As struct_measdata   ' MeasData(ő呪荀ڐ)

    ReadSetupData = False       'ǂݏotOEZbg
    
ErrEnd:
    On Error GoTo 0 '*** ON ERROR reset ****
    Exit Function

ErrReadFile:
    MsgBox fn & "Error line[ " & CLng(lcnt) & " ]: " + vbCrLf + vbCrLf + CStr(aryTemp(0)), vbOKOnly Or vbCritical
ErrProductType:
    GoTo ErrEnd

End Function

'
'The setting condition data is read from the CSV file.
'
Public Function ReadCsvFile(fn As String) As Boolean
    Dim FileNum As Long
    Dim blnRtn As Boolean
    Dim fn_cal As String
    
    ReadCsvFile = False
    FileNum = FreeFile
    Open fn For Input As #FileNum
        blnRtn = ReadSetupData(fn, FileNum)
    Close #FileNum
    
    ReadCsvFile = blnRtn
End Function


Public Sub SaveTraceData(fn As String)
    Dim FileNum As Long
    Dim lcnt As Long
    Dim s As String
    Dim i As Integer
    Dim points As Long
    Dim strTemp As Variant
    Dim TrcFmt As Long
    '
    On Error GoTo ErrSaveTrace
    
    FileNum = FreeFile
    
    lcnt = 0
    s = cnt_CSV_SEPA_CHAR
    points = ChInfo(lngACh).lngTotP - 1
    TrcFmt = ChInfo(lngACh).WaveFrmt
    Open fn For Output As #FileNum
        For i = 0 To points
            strTemp = CStr(i + 1) & s & Format(BufFrq(i, lngACh), cnt_FREQ_TO_STR)
            If BufLvl(i, lngACh) <> ERR_VALUE Then  'p[|?
                strTemp = strTemp & s & Format(BufLvl(i, lngACh), cnt_LEVL_TO_STR)
            End If
            If (TrcFmt And WAVE_FORMAT_LOGMAG) <> 0 Then
                strTemp = strTemp & s & Format(BufLgm(i, lngACh), cnt_LEVL_TO_STR)
            End If
            If (TrcFmt And WAVE_FORMAT____SWR) <> 0 Then
                strTemp = strTemp & s & Format(BufSwr(i, lngACh), cnt_LEVL_TO_STR)
            End If
            strTemp = strTemp & s
            lcnt = RdWtData(FileNum, lcnt, strTemp, s, cnt_SAVE)
        Next i
    Close #FileNum
    
    On Error GoTo 0
    Exit Sub

ErrSaveTrace:
    Close #FileNum
    MsgBox fn & "Error:" & Str(Err.Number) & vbCrLf & Error(Err.Number), vbOKOnly Or vbCritical
    On Error GoTo 0

End Sub

'
'   Save measurement data
'
Public Function SaveMeasData(fn As String, fileno As Long) As Boolean
    Dim ch As Long
    Dim s As String
    Dim lcnt As Long
    Dim strTemp As Variant
    Dim i As Integer
    Dim str_sw As String
    Dim act_format As Integer
    Dim view_wave As Integer
    Dim plog_max As Long
    Dim plog_min As Long
    Dim p0deg As Long
    Dim pdel_max As Long
    Dim pdel_min As Long
    Dim pswr_max As Long
    Dim pswr_min As Long

    If FileDlg.FileExists(fn) = True Then
        On Error Resume Next
        Kill fn
        On Error GoTo 0
    End If
    '
    On Error GoTo ErrSaveFile

    s = cnt_CSV_SEPA_CHAR

    lcnt = 0

    ' Application Name
    strTemp = cnt_APP_NAME_TITLE & s & cnt_CHECK_APPLI_NAME
    lcnt = RdWtData(fileno, lcnt, strTemp, s, cnt_SAVE)

    ' CSV Sheet Revsion
    strTemp = cnt_CSV_SHET_TITLE & s & strCsvVer
    lcnt = RdWtData(fileno, lcnt, strTemp, s, cnt_SAVE)

    ' Board Number
    strTemp = cnt_BD__NUMB_TITLE & s & frmMain.Combo_bd.ListIndex
    lcnt = RdWtData(fileno, lcnt, strTemp, s, cnt_SAVE)

    ' IP Address
    strTemp = cnt_IP__ADDR_TITLE & s & frmMain.Text_con.Text
    lcnt = RdWtData(fileno, lcnt, strTemp, s, cnt_SAVE)

    ' Product Name
    strTemp = cnt_PD__NAME_TITLE & s & NA_ProductName
    lcnt = RdWtData(fileno, lcnt, strTemp, s, cnt_SAVE)

    ' Serial Number
    strTemp = cnt_PD_SERNO_TITLE & s & NA_SerialNumber
    lcnt = RdWtData(fileno, lcnt, strTemp, s, cnt_SAVE)

    ' Number Of Channel
    strTemp = cnt_PD_NUMCH_TITLE & s & CStr(ChNum)
    lcnt = RdWtData(fileno, lcnt, strTemp, s, cnt_SAVE)

    For ch = 0 To ChNum - 1
        ' Channel Title
        strTemp = cnt_CH__NO___TITLE & s & "CH" & CStr(ch + 1)
        lcnt = RdWtData(fileno, lcnt, strTemp, s, cnt_SAVE)

        ' CAL status (Cor/C?/C!)
        strTemp = cnt_CAL_COR__TITLE & s & frm_CH(ch).Text_hd.Text
        lcnt = RdWtData(fileno, lcnt, strTemp, s, cnt_SAVE)

        'Measurement
        strTemp = cnt_MEAS_____TITLE
        For i = 0 To frm_CH(ch).Option_msr.UBound
            If frm_CH(ch).Option_msr(i).Value = True Then
                strTemp = strTemp & s & frm_CH(ch).Option_msr(i).Caption
                Exit For
            End If
        Next i
        lcnt = RdWtData(fileno, lcnt, strTemp, s, cnt_SAVE)

        'Information on format
        strTemp = cnt_FMT_INF__TITLE & s & cnt_FMT_DIV__TITLE & s & cnt_FMT_REFV_TITLE & s & cnt_FMT_REFP_TITLE
        lcnt = RdWtData(fileno, lcnt, strTemp, s, cnt_SAVE)
        'LOGMAG Scale (/DIV, Rev Val, Ref Posi)
        strTemp = cnt_FMT_LGM__TITLE & s '& CStr(Mscl.div) & s & CStr(Mscl.ref) & s & CStr(Mscl.pos)
        lcnt = RdWtData(fileno, lcnt, strTemp, s, cnt_SAVE)

        ' Number of Freq.Segment
        strTemp = cnt_FRQ_SEGM_TITLE & s & CStr(ChInfo(ch).StimuNum)
        lcnt = RdWtData(fileno, lcnt, strTemp, s, cnt_SAVE)

        strTemp = cnt_SEG_NO___TITLE & s & cnt_FRQ_STAR_TITLE & s & cnt_FRQ_STOP_TITLE & s & cnt_FRQ_POIN_TITLE & s & _
                cnt_FRQ_STPW_TITLE & s & cnt_FRQ_SPPW_TITLE & s & cnt_FRQ_RBW__TITLE & s & cnt_FRQ_STTM_TITLE
        lcnt = RdWtData(fileno, lcnt, strTemp, s, cnt_SAVE)

        For i = 0 To ChInfo(ch).StimuNum - 1
            With CH_Stimu(i, ch)
                If frm_CH(ch).Check_pw2.Value = 1 Then
                    strTemp = CStr(i + 1) & s & Format(dblRound(.dblFreq1, Unit_mega, cnt_FREQ_ADJUST), cnt_FREQ_TO_STR) _
                        & s & Format(dblRound(.dblFreq2, Unit_mega, cnt_FREQ_ADJUST), cnt_FREQ_TO_STR) & _
                    s & CStr(.lngPntN) & s & Format(.sngPow1, cnt_LEVL_TO_STR) & s & Format(.sngPow2, cnt_LEVL_TO_STR) & s & _
                    Format(dblRound(.sngRbw, Unit_k, cnt_RBW_ADJUST), cnt_RBW_TO_STR) & s & _
                    Format(dblRound(.sngStime, Unit_m, cnt_STTM_ADJUST), cnt_STTM_TO_STR)
                Else
                    strTemp = CStr(i + 1) & s & Format(dblRound(.dblFreq1, Unit_mega, cnt_FREQ_ADJUST), cnt_FREQ_TO_STR) _
                        & s & Format(dblRound(.dblFreq2, Unit_mega, cnt_FREQ_ADJUST), cnt_FREQ_TO_STR) & _
                    s & CStr(.lngPntN) & s & Format(.sngPow1, cnt_LEVL_TO_STR) & s & Format(.sngPow1, cnt_LEVL_TO_STR) & s & _
                    Format(dblRound(.sngRbw, Unit_k, cnt_RBW_ADJUST), cnt_RBW_TO_STR) & s & _
                    Format(dblRound(.sngStime, Unit_m, cnt_STTM_ADJUST), cnt_STTM_TO_STR)
                End If
            End With
        lcnt = RdWtData(fileno, lcnt, strTemp, s, cnt_SAVE)
        Next i
        
        ' Number of Measurement
        strTemp = cnt_MEAS_NUM_TITLE & s & CStr(ChInfo(ch).MeasSegNum)
        
        lcnt = RdWtData(fileno, lcnt, strTemp, s, cnt_SAVE)
        'Measurement Number
        strTemp = cnt_MEAS_NO_TITLE & s & cnt_MEAS_TT_TITLE & s & cnt_MEAS_JG_TITLE & s & cnt_MEAS_TN_TITLE & s & _
                cnt_MEAS_CM_TITLE & s & cnt_MEAS_ST_TITLE & s & cnt_MEAS_SP_TITLE & s & cnt_MEAS_LD_TITLE & s & _
                cnt_MEAS_LC_TITLE & s & cnt_MEAS_LW_TITLE & s & cnt_MEAS_UC_TITLE & s & cnt_MEAS_UP_TITLE & s & _
                cnt_MEAS_LF_TITLE & s & cnt_MEAS_UF_TITLE
        lcnt = RdWtData(fileno, lcnt, strTemp, s, cnt_SAVE)

        For i = 0 To ChInfo(ch).MeasSegNum - 1
            With MeasInfo(ch, i)
                Call CnvOnOffSw(cnt_INT_TO_STR, str_sw, .JudgeValid) 'Judge Valid(ON)/Invalid(OFF)
                strTemp = CStr(i + 1) & s & .Title & s & str_sw & s & CStr(.RefFmtNo)
                Call GetMeasType(cnt_INT_TO_STR, str_sw, .MeasType)
                strTemp = strTemp & s & str_sw
                strTemp = strTemp & s & Format(dblRound(.Start, Unit_mega, cnt_FREQ_ADJUST), cnt_FREQ_TO_STR)
                strTemp = strTemp & s & Format(dblRound(.Stop, Unit_mega, cnt_FREQ_ADJUST), cnt_FREQ_TO_STR)
                Call CnvOnOffSw(cnt_INT_TO_STR, str_sw, .LmtDspFlg)         'Limit Line Display (ON/OFF)
                strTemp = strTemp & s & str_sw
                Call CnvOnOffSw(cnt_INT_TO_STR, str_sw, .LwLmtLvlFlg)       'Level Lower Limit Check (ON/OFF)
                strTemp = strTemp & s & str_sw
                strTemp = strTemp & s & Format(.LwLmtLvl, cnt_LEVL_TO_STR)  'Level LowerL imit
                Call CnvOnOffSw(cnt_INT_TO_STR, str_sw, .UpLmtLvlFlg)       'Level Upper Limit Check (ON/OFF)
                strTemp = strTemp & s & str_sw
                strTemp = strTemp & s & Format(.UpLmtLvl, cnt_LEVL_TO_STR)  'Level Upper imit
                strTemp = strTemp & s & Format(dblRound(.LwLmtFrq, Unit_mega, cnt_FREQ_ADJUST), cnt_FREQ_TO_STR)
                strTemp = strTemp & s & Format(dblRound(.UpLmtFrq, Unit_mega, cnt_FREQ_ADJUST), cnt_FREQ_TO_STR)
            End With
            lcnt = RdWtData(fileno, lcnt, strTemp, s, cnt_SAVE)
        Next i
    Next ch

    On Error GoTo 0
    Exit Function

ErrSaveFile:
    Close #fileno
    MsgBox fn & "Error:" & Str(Err.Number) & vbCrLf & Error(Err.Number), vbOKOnly Or vbCritical
    On Error GoTo 0
End Function

'
Public Sub SaveCalFile(ByVal mx_ch As Long, ByVal fn As String)
    Dim fileno As Long
    Dim i As Integer
    Dim ch As Integer

    fn = Mid(fn, 1, Len(fn) - 3)
    fn = fn & "bin"
    On Error GoTo svcalerr
    If FileDlg.FileExists(fn) = True Then
        Kill fn
    End If
    
    fileno = FreeFile
    '
    Open fn For Binary Access Write As #fileno Len = Len(ChInfo(ACT_CH1).Correct.cal1(0))
        For ch = ACT_CH1 To mx_ch - 1
            With ChInfo(ch)
                For i = 0 To .lngTotP - 1
                    With .Correct
                        Put #fileno, , .cal1(i * 2)
                        Put #fileno, , .cal1(i * 2 + 1)
                        Put #fileno, , .cal2(i * 2)
                        Put #fileno, , .cal2(i * 2 + 1)
                        Put #fileno, , .cal3(i * 2)
                        Put #fileno, , .cal3(i * 2 + 1)
                    End With
                Next i
            End With
        Next ch
    Close #fileno
    On Error GoTo 0
    Exit Sub

svcalerr:
    MsgBox "Error:" & Str(Err.Number) & vbCrLf & Error(Err.Number), vbOKOnly Or vbCritical
    Close #fileno
    On Error GoTo 0
End Sub


'
'The setting condition data and the measurement data is write in the CSV file.
'
Public Function SaveCsvFile(fn As String) As Boolean
    Dim FileNum As Long
    Dim blnRtn As Boolean
    '
    SaveCsvFile = False
    FileNum = FreeFile
    Open fn For Output As #FileNum
        blnRtn = SaveMeasData(fn, FileNum)
    Close #FileNum
    SaveCsvFile = blnRtn
End Function

'
'Check File time stamp
'
Public Function ChkFileTimeStamp(ByRef f1time As Date, ByRef f2time As Date) As Boolean

    ChkFileTimeStamp = True
    If f1time > f2time Then
        ChkFileTimeStamp = False
    End If

End Function

'
'get File time stamp
'
Public Sub GetFileTimeStamp(ByRef fn As String, ByRef ftime As Date)
    ftime = FileDateTime(fn)
End Sub
